/*
 * Decompiled with CFR 0.152.
 */
package com.cyberbotics.webots.controller;

import com.cyberbotics.webots.controller.Brake;
import com.cyberbotics.webots.controller.Device;
import com.cyberbotics.webots.controller.PositionSensor;
import com.cyberbotics.webots.controller.Robot;
import com.cyberbotics.webots.controller.wrapperJNI;

public class Motor
extends Device {
    private transient long swigCPtr;
    private Brake brake;
    private PositionSensor positionSensor;
    public static final int ROTATIONAL = 0;
    public static final int LINEAR = 1;

    protected Motor(long l, boolean bl) {
        super(wrapperJNI.Motor_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(Motor motor) {
        return motor == null ? 0L : motor.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                wrapperJNI.delete_Motor(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public Brake getBrake() {
        if (this.brake == null) {
            this.brake = (Brake)Robot.getDevice(this.getBrakeTag());
        }
        return this.brake;
    }

    public PositionSensor getPositionSensor() {
        if (this.positionSensor == null) {
            this.positionSensor = (PositionSensor)Robot.getDevice(this.getPositionSensorTag());
        }
        return this.positionSensor;
    }

    public Motor(String string) {
        this(wrapperJNI.new_Motor(string), true);
    }

    public void setPosition(double d) {
        wrapperJNI.Motor_setPosition(this.swigCPtr, this, d);
    }

    public void setVelocity(double d) {
        wrapperJNI.Motor_setVelocity(this.swigCPtr, this, d);
    }

    public void setAcceleration(double d) {
        wrapperJNI.Motor_setAcceleration(this.swigCPtr, this, d);
    }

    public void setAvailableForce(double d) {
        wrapperJNI.Motor_setAvailableForce(this.swigCPtr, this, d);
    }

    public void setAvailableTorque(double d) {
        wrapperJNI.Motor_setAvailableTorque(this.swigCPtr, this, d);
    }

    public void setControlPID(double d, double d2, double d3) {
        wrapperJNI.Motor_setControlPID(this.swigCPtr, this, d, d2, d3);
    }

    public double getTargetPosition() {
        return wrapperJNI.Motor_getTargetPosition(this.swigCPtr, this);
    }

    public double getMinPosition() {
        return wrapperJNI.Motor_getMinPosition(this.swigCPtr, this);
    }

    public double getMaxPosition() {
        return wrapperJNI.Motor_getMaxPosition(this.swigCPtr, this);
    }

    public double getVelocity() {
        return wrapperJNI.Motor_getVelocity(this.swigCPtr, this);
    }

    public double getMaxVelocity() {
        return wrapperJNI.Motor_getMaxVelocity(this.swigCPtr, this);
    }

    public double getAcceleration() {
        return wrapperJNI.Motor_getAcceleration(this.swigCPtr, this);
    }

    public double getAvailableForce() {
        return wrapperJNI.Motor_getAvailableForce(this.swigCPtr, this);
    }

    public double getMaxForce() {
        return wrapperJNI.Motor_getMaxForce(this.swigCPtr, this);
    }

    public double getAvailableTorque() {
        return wrapperJNI.Motor_getAvailableTorque(this.swigCPtr, this);
    }

    public double getMaxTorque() {
        return wrapperJNI.Motor_getMaxTorque(this.swigCPtr, this);
    }

    public double getMultiplier() {
        return wrapperJNI.Motor_getMultiplier(this.swigCPtr, this);
    }

    public void enableForceFeedback(int n) {
        wrapperJNI.Motor_enableForceFeedback(this.swigCPtr, this, n);
    }

    public void disableForceFeedback() {
        wrapperJNI.Motor_disableForceFeedback(this.swigCPtr, this);
    }

    public int getForceFeedbackSamplingPeriod() {
        return wrapperJNI.Motor_getForceFeedbackSamplingPeriod(this.swigCPtr, this);
    }

    public double getForceFeedback() {
        return wrapperJNI.Motor_getForceFeedback(this.swigCPtr, this);
    }

    public void enableTorqueFeedback(int n) {
        wrapperJNI.Motor_enableTorqueFeedback(this.swigCPtr, this, n);
    }

    public void disableTorqueFeedback() {
        wrapperJNI.Motor_disableTorqueFeedback(this.swigCPtr, this);
    }

    public int getTorqueFeedbackSamplingPeriod() {
        return wrapperJNI.Motor_getTorqueFeedbackSamplingPeriod(this.swigCPtr, this);
    }

    public double getTorqueFeedback() {
        return wrapperJNI.Motor_getTorqueFeedback(this.swigCPtr, this);
    }

    public void setForce(double d) {
        wrapperJNI.Motor_setForce(this.swigCPtr, this, d);
    }

    public void setTorque(double d) {
        wrapperJNI.Motor_setTorque(this.swigCPtr, this, d);
    }

    public int getType() {
        return wrapperJNI.Motor_getType(this.swigCPtr, this);
    }

    private Brake getBrakePrivate() {
        long l = wrapperJNI.Motor_getBrakePrivate(this.swigCPtr, this);
        return l == 0L ? null : new Brake(l, false);
    }

    private PositionSensor getPositionSensorPrivate() {
        long l = wrapperJNI.Motor_getPositionSensorPrivate(this.swigCPtr, this);
        return l == 0L ? null : new PositionSensor(l, false);
    }

    public int getBrakeTag() {
        return wrapperJNI.Motor_getBrakeTag(this.swigCPtr, this);
    }

    public int getPositionSensorTag() {
        return wrapperJNI.Motor_getPositionSensorTag(this.swigCPtr, this);
    }
}

