/*
 * Decompiled with CFR 0.152.
 */
package com.cyberbotics.webots.controller;

import com.cyberbotics.webots.controller.Accelerometer;
import com.cyberbotics.webots.controller.Altimeter;
import com.cyberbotics.webots.controller.Brake;
import com.cyberbotics.webots.controller.Camera;
import com.cyberbotics.webots.controller.Compass;
import com.cyberbotics.webots.controller.Connector;
import com.cyberbotics.webots.controller.Device;
import com.cyberbotics.webots.controller.Display;
import com.cyberbotics.webots.controller.DistanceSensor;
import com.cyberbotics.webots.controller.Emitter;
import com.cyberbotics.webots.controller.GPS;
import com.cyberbotics.webots.controller.Gyro;
import com.cyberbotics.webots.controller.InertialUnit;
import com.cyberbotics.webots.controller.Joystick;
import com.cyberbotics.webots.controller.Keyboard;
import com.cyberbotics.webots.controller.LED;
import com.cyberbotics.webots.controller.Lidar;
import com.cyberbotics.webots.controller.LightSensor;
import com.cyberbotics.webots.controller.Motor;
import com.cyberbotics.webots.controller.Mouse;
import com.cyberbotics.webots.controller.Pen;
import com.cyberbotics.webots.controller.PositionSensor;
import com.cyberbotics.webots.controller.Radar;
import com.cyberbotics.webots.controller.RangeFinder;
import com.cyberbotics.webots.controller.Receiver;
import com.cyberbotics.webots.controller.Skin;
import com.cyberbotics.webots.controller.Speaker;
import com.cyberbotics.webots.controller.TouchSensor;
import com.cyberbotics.webots.controller.wrapperJNI;

public class Robot {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
    private static Device[] devices = null;
    private Joystick joystick = new Joystick();
    private Keyboard keyboard = new Keyboard();
    private Mouse mouse = new Mouse();
    public static final int MODE_SIMULATION = 0;
    public static final int MODE_CROSS_COMPILATION = 1;
    public static final int MODE_REMOTE_CONTROL = 2;
    public static final int EVENT_QUIT = -1;
    public static final int EVENT_NO_EVENT = 0;
    public static final int EVENT_MOUSE_CLICK = 1;
    public static final int EVENT_MOUSE_MOVE = 2;
    public static final int EVENT_KEYBOARD = 4;
    public static final int EVENT_JOYSTICK_BUTTON = 8;
    public static final int EVENT_JOYSTICK_AXIS = 16;
    public static final int EVENT_JOYSTICK_POV = 32;

    protected Robot(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Robot robot) {
        return robot == null ? 0L : robot.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                wrapperJNI.delete_Robot(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    protected Accelerometer createAccelerometer(String string) {
        return new Accelerometer(string);
    }

    public Accelerometer getAccelerometer(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 34)) {
            return null;
        }
        return (Accelerometer)this.getOrCreateDevice(n);
    }

    protected Altimeter createAltimeter(String string) {
        return new Altimeter(string);
    }

    public Altimeter getAltimeter(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 35)) {
            return null;
        }
        return (Altimeter)this.getOrCreateDevice(n);
    }

    protected Brake createBrake(String string) {
        return new Brake(string);
    }

    public Brake getBrake(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 36)) {
            return null;
        }
        return (Brake)this.getOrCreateDevice(n);
    }

    protected Camera createCamera(String string) {
        return new Camera(string);
    }

    public Camera getCamera(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 37)) {
            return null;
        }
        return (Camera)this.getOrCreateDevice(n);
    }

    protected Compass createCompass(String string) {
        return new Compass(string);
    }

    public Compass getCompass(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 38)) {
            return null;
        }
        return (Compass)this.getOrCreateDevice(n);
    }

    protected Connector createConnector(String string) {
        return new Connector(string);
    }

    public Connector getConnector(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 39)) {
            return null;
        }
        return (Connector)this.getOrCreateDevice(n);
    }

    protected Display createDisplay(String string) {
        return new Display(string);
    }

    public Display getDisplay(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 40)) {
            return null;
        }
        return (Display)this.getOrCreateDevice(n);
    }

    protected DistanceSensor createDistanceSensor(String string) {
        return new DistanceSensor(string);
    }

    public DistanceSensor getDistanceSensor(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 41)) {
            return null;
        }
        return (DistanceSensor)this.getOrCreateDevice(n);
    }

    protected Emitter createEmitter(String string) {
        return new Emitter(string);
    }

    public Emitter getEmitter(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 42)) {
            return null;
        }
        return (Emitter)this.getOrCreateDevice(n);
    }

    protected GPS createGPS(String string) {
        return new GPS(string);
    }

    public GPS getGPS(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 43)) {
            return null;
        }
        return (GPS)this.getOrCreateDevice(n);
    }

    protected Gyro createGyro(String string) {
        return new Gyro(string);
    }

    public Gyro getGyro(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 44)) {
            return null;
        }
        return (Gyro)this.getOrCreateDevice(n);
    }

    protected InertialUnit createInertialUnit(String string) {
        return new InertialUnit(string);
    }

    public InertialUnit getInertialUnit(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 45)) {
            return null;
        }
        return (InertialUnit)this.getOrCreateDevice(n);
    }

    public Joystick getJoystick() {
        return this.joystick;
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    protected LED createLED(String string) {
        return new LED(string);
    }

    public LED getLED(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 46)) {
            return null;
        }
        return (LED)this.getOrCreateDevice(n);
    }

    protected Lidar createLidar(String string) {
        return new Lidar(string);
    }

    public Lidar getLidar(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 47)) {
            return null;
        }
        return (Lidar)this.getOrCreateDevice(n);
    }

    protected LightSensor createLightSensor(String string) {
        return new LightSensor(string);
    }

    public LightSensor getLightSensor(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 48)) {
            return null;
        }
        return (LightSensor)this.getOrCreateDevice(n);
    }

    protected Motor createMotor(String string) {
        return new Motor(string);
    }

    public Motor getMotor(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 49) && !Device.hasType(n, 56)) {
            return null;
        }
        return (Motor)this.getOrCreateDevice(n);
    }

    public Mouse getMouse() {
        return this.mouse;
    }

    protected Pen createPen(String string) {
        return new Pen(string);
    }

    public Pen getPen(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 50)) {
            return null;
        }
        return (Pen)this.getOrCreateDevice(n);
    }

    protected PositionSensor createPositionSensor(String string) {
        return new PositionSensor(string);
    }

    public PositionSensor getPositionSensor(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 51)) {
            return null;
        }
        return (PositionSensor)this.getOrCreateDevice(n);
    }

    protected Radar createRadar(String string) {
        return new Radar(string);
    }

    public Radar getRadar(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 53)) {
            return null;
        }
        return (Radar)this.getOrCreateDevice(n);
    }

    protected RangeFinder createRangeFinder(String string) {
        return new RangeFinder(string);
    }

    public RangeFinder getRangeFinder(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 54)) {
            return null;
        }
        return (RangeFinder)this.getOrCreateDevice(n);
    }

    protected Receiver createReceiver(String string) {
        return new Receiver(string);
    }

    public Receiver getReceiver(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 55)) {
            return null;
        }
        return (Receiver)this.getOrCreateDevice(n);
    }

    protected Skin createSkin(String string) {
        return new Skin(string);
    }

    public Skin getSkin(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 57)) {
            return null;
        }
        return (Skin)this.getOrCreateDevice(n);
    }

    protected Speaker createSpeaker(String string) {
        return new Speaker(string);
    }

    public Speaker getSpeaker(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 58)) {
            return null;
        }
        return (Speaker)this.getOrCreateDevice(n);
    }

    protected TouchSensor createTouchSensor(String string) {
        return new TouchSensor(string);
    }

    public TouchSensor getTouchSensor(String string) {
        int n = Robot.getDeviceTagFromName(string);
        if (!Device.hasType(n, 59)) {
            return null;
        }
        return (TouchSensor)this.getOrCreateDevice(n);
    }

    public Device getDeviceByIndex(int n) {
        return this.getOrCreateDevice(Robot.getDeviceTagFromIndex(n));
    }

    public static Device getDevice(int n) {
        if (n == 0 || devices == null || n >= devices.length) {
            return null;
        }
        return devices[n];
    }

    private Device getOrCreateDevice(int n) {
        if (n == 0) {
            return null;
        }
        int n2 = this.getNumberOfDevices();
        if (devices != null && devices.length == n2 + 1 && n < devices.length) {
            return devices[n];
        }
        if (n > n2) {
            return null;
        }
        devices = new Device[n2 + 1];
        block26: for (int i = 0; i < n2; ++i) {
            int n3 = Robot.getDeviceTagFromIndex(i);
            String string = Robot.getDeviceNameFromTag(n3);
            switch (Robot.getDeviceTypeFromTag(n3)) {
                case 34: {
                    Robot.devices[n3] = this.createAccelerometer(string);
                    continue block26;
                }
                case 35: {
                    Robot.devices[n3] = this.createAltimeter(string);
                    continue block26;
                }
                case 36: {
                    Robot.devices[n3] = this.createBrake(string);
                    continue block26;
                }
                case 37: {
                    Robot.devices[n3] = this.createCamera(string);
                    continue block26;
                }
                case 38: {
                    Robot.devices[n3] = this.createCompass(string);
                    continue block26;
                }
                case 39: {
                    Robot.devices[n3] = this.createConnector(string);
                    continue block26;
                }
                case 40: {
                    Robot.devices[n3] = this.createDisplay(string);
                    continue block26;
                }
                case 41: {
                    Robot.devices[n3] = this.createDistanceSensor(string);
                    continue block26;
                }
                case 42: {
                    Robot.devices[n3] = this.createEmitter(string);
                    continue block26;
                }
                case 43: {
                    Robot.devices[n3] = this.createGPS(string);
                    continue block26;
                }
                case 44: {
                    Robot.devices[n3] = this.createGyro(string);
                    continue block26;
                }
                case 45: {
                    Robot.devices[n3] = this.createInertialUnit(string);
                    continue block26;
                }
                case 46: {
                    Robot.devices[n3] = this.createLED(string);
                    continue block26;
                }
                case 47: {
                    Robot.devices[n3] = this.createLidar(string);
                    continue block26;
                }
                case 48: {
                    Robot.devices[n3] = this.createLightSensor(string);
                    continue block26;
                }
                case 49: 
                case 56: {
                    Robot.devices[n3] = this.createMotor(string);
                    continue block26;
                }
                case 50: {
                    Robot.devices[n3] = this.createPen(string);
                    continue block26;
                }
                case 51: {
                    Robot.devices[n3] = this.createPositionSensor(string);
                    continue block26;
                }
                case 53: {
                    Robot.devices[n3] = this.createRadar(string);
                    continue block26;
                }
                case 54: {
                    Robot.devices[n3] = this.createRangeFinder(string);
                    continue block26;
                }
                case 55: {
                    Robot.devices[n3] = this.createReceiver(string);
                    continue block26;
                }
                case 57: {
                    Robot.devices[n3] = this.createSkin(string);
                    continue block26;
                }
                case 58: {
                    Robot.devices[n3] = this.createSpeaker(string);
                    continue block26;
                }
                case 59: {
                    Robot.devices[n3] = this.createTouchSensor(string);
                    continue block26;
                }
                default: {
                    Robot.devices[n3] = null;
                }
            }
        }
        return devices[n];
    }

    public Robot() {
        this(wrapperJNI.new_Robot(), true);
    }

    public int step(int n) {
        return wrapperJNI.Robot_step(this.swigCPtr, this, n);
    }

    public int stepBegin(int n) {
        return wrapperJNI.Robot_stepBegin(this.swigCPtr, this, n);
    }

    public int stepEnd() {
        return wrapperJNI.Robot_stepEnd(this.swigCPtr, this);
    }

    public int waitForUserInputEvent(int n, int n2) {
        return wrapperJNI.Robot_waitForUserInputEvent(this.swigCPtr, this, n, n2);
    }

    public String getName() {
        return wrapperJNI.Robot_getName(this.swigCPtr, this);
    }

    public String getUrdf(String string) {
        return wrapperJNI.Robot_getUrdf__SWIG_0(this.swigCPtr, this, string);
    }

    public String getUrdf() {
        return wrapperJNI.Robot_getUrdf__SWIG_1(this.swigCPtr, this);
    }

    public double getTime() {
        return wrapperJNI.Robot_getTime(this.swigCPtr, this);
    }

    public String getModel() {
        return wrapperJNI.Robot_getModel(this.swigCPtr, this);
    }

    public String getCustomData() {
        return wrapperJNI.Robot_getCustomData(this.swigCPtr, this);
    }

    public void setCustomData(String string) {
        wrapperJNI.Robot_setCustomData(this.swigCPtr, this, string);
    }

    public int getMode() {
        return wrapperJNI.Robot_getMode(this.swigCPtr, this);
    }

    public void setMode(int n, String string) {
        wrapperJNI.Robot_setMode(this.swigCPtr, this, n, string);
    }

    public boolean getSupervisor() {
        return wrapperJNI.Robot_getSupervisor(this.swigCPtr, this);
    }

    public boolean getSynchronization() {
        return wrapperJNI.Robot_getSynchronization(this.swigCPtr, this);
    }

    public String getProjectPath() {
        return wrapperJNI.Robot_getProjectPath(this.swigCPtr, this);
    }

    public String getWorldPath() {
        return wrapperJNI.Robot_getWorldPath(this.swigCPtr, this);
    }

    public double getBasicTimeStep() {
        return wrapperJNI.Robot_getBasicTimeStep(this.swigCPtr, this);
    }

    public int getNumberOfDevices() {
        return wrapperJNI.Robot_getNumberOfDevices(this.swigCPtr, this);
    }

    private Device getDeviceByIndexPrivate(int n) {
        long l = wrapperJNI.Robot_getDeviceByIndexPrivate(this.swigCPtr, this, n);
        return l == 0L ? null : new Device(l, false);
    }

    public Device getDevice(String string) {
        long l = wrapperJNI.Robot_getDevice(this.swigCPtr, this, string);
        return l == 0L ? null : new Device(l, false);
    }

    public void batterySensorEnable(int n) {
        wrapperJNI.Robot_batterySensorEnable(this.swigCPtr, this, n);
    }

    public void batterySensorDisable() {
        wrapperJNI.Robot_batterySensorDisable(this.swigCPtr, this);
    }

    public int batterySensorGetSamplingPeriod() {
        return wrapperJNI.Robot_batterySensorGetSamplingPeriod(this.swigCPtr, this);
    }

    public double batterySensorGetValue() {
        return wrapperJNI.Robot_batterySensorGetValue(this.swigCPtr, this);
    }

    public void wwiSendText(String string) {
        wrapperJNI.Robot_wwiSendText(this.swigCPtr, this, string);
    }

    public String wwiReceiveText() {
        return wrapperJNI.Robot_wwiReceiveText(this.swigCPtr, this);
    }

    public String getData() {
        return wrapperJNI.Robot_getData(this.swigCPtr, this);
    }

    public void setData(String string) {
        wrapperJNI.Robot_setData(this.swigCPtr, this, string);
    }

    public static Device getDeviceFromTag(int n) {
        long l = wrapperJNI.Robot_getDeviceFromTag(n);
        return l == 0L ? null : new Device(l, false);
    }

    private static int getDeviceTypeFromTag(int n) {
        return wrapperJNI.Robot_getDeviceTypeFromTag(n);
    }

    private static String getDeviceNameFromTag(int n) {
        return wrapperJNI.Robot_getDeviceNameFromTag(n);
    }

    private static int getDeviceTagFromIndex(int n) {
        return wrapperJNI.Robot_getDeviceTagFromIndex(n);
    }

    public static int getDeviceTagFromName(String string) {
        return wrapperJNI.Robot_getDeviceTagFromName(string);
    }
}

