/*
 * Decompiled with CFR 0.152.
 */
package com.cyberbotics.webots.controller;

import com.cyberbotics.webots.controller.CameraRecognitionObject;
import com.cyberbotics.webots.controller.Device;
import com.cyberbotics.webots.controller.wrapperJNI;

public class Camera
extends Device {
    private transient long swigCPtr;

    protected Camera(long l, boolean bl) {
        super(wrapperJNI.Camera_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(Camera camera) {
        return camera == null ? 0L : camera.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                wrapperJNI.delete_Camera(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static int imageGetRed(int[] nArray, int n, int n2, int n3) {
        return (nArray[n3 * n + n2] & 0xFF0000) >> 16 & 0xFF;
    }

    public static int imageGetGreen(int[] nArray, int n, int n2, int n3) {
        return (nArray[n3 * n + n2] & 0xFF00) >> 8 & 0xFF;
    }

    public static int imageGetBlue(int[] nArray, int n, int n2, int n3) {
        return nArray[n3 * n + n2] & 0xFF;
    }

    public static int imageGetGray(int[] nArray, int n, int n2, int n3) {
        int n4 = nArray[n3 * n + n2] & 0xFFFFFF;
        return ((n4 >> 16 & 0xFF) + (n4 >> 8 & 0xFF) + (n4 & 0xFF)) / 3;
    }

    public static int imageGetGrey(int[] nArray, int n, int n2, int n3) {
        return Camera.imageGetGray(nArray, n, n2, n3);
    }

    public static int pixelGetRed(int n) {
        return (n & 0xFF0000) >> 16 & 0xFF;
    }

    public static int pixelGetGreen(int n) {
        return (n & 0xFF00) >> 8 & 0xFF;
    }

    public static int pixelGetBlue(int n) {
        return n & 0xFF;
    }

    public static int pixelGetGray(int n) {
        return ((n >> 16 & 0xFF) + (n >> 8 & 0xFF) + (n & 0xFF)) / 3;
    }

    public static int pixelGetGrey(int n) {
        return Camera.pixelGetGray(n);
    }

    public CameraRecognitionObject[] getRecognitionObjects() {
        int n = wrapperJNI.Camera_getRecognitionNumberOfObjects(this.swigCPtr, this);
        CameraRecognitionObject[] cameraRecognitionObjectArray = new CameraRecognitionObject[n];
        for (int i = 0; i < n; ++i) {
            cameraRecognitionObjectArray[i] = this.getRecognitionObject(i);
        }
        return cameraRecognitionObjectArray;
    }

    public Camera(String string) {
        this(wrapperJNI.new_Camera(string), true);
    }

    public void enable(int n) {
        wrapperJNI.Camera_enable(this.swigCPtr, this, n);
    }

    public void disable() {
        wrapperJNI.Camera_disable(this.swigCPtr, this);
    }

    public int getSamplingPeriod() {
        return wrapperJNI.Camera_getSamplingPeriod(this.swigCPtr, this);
    }

    public int[] getImage() {
        return wrapperJNI.Camera_getImage(this.swigCPtr, this);
    }

    public int getWidth() {
        return wrapperJNI.Camera_getWidth(this.swigCPtr, this);
    }

    public int getHeight() {
        return wrapperJNI.Camera_getHeight(this.swigCPtr, this);
    }

    public double getFov() {
        return wrapperJNI.Camera_getFov(this.swigCPtr, this);
    }

    public double getMaxFov() {
        return wrapperJNI.Camera_getMaxFov(this.swigCPtr, this);
    }

    public double getMinFov() {
        return wrapperJNI.Camera_getMinFov(this.swigCPtr, this);
    }

    public void setFov(double d) {
        wrapperJNI.Camera_setFov(this.swigCPtr, this, d);
    }

    public double getExposure() {
        return wrapperJNI.Camera_getExposure(this.swigCPtr, this);
    }

    public void setExposure(double d) {
        wrapperJNI.Camera_setExposure(this.swigCPtr, this, d);
    }

    public double getFocalLength() {
        return wrapperJNI.Camera_getFocalLength(this.swigCPtr, this);
    }

    public double getFocalDistance() {
        return wrapperJNI.Camera_getFocalDistance(this.swigCPtr, this);
    }

    public double getMaxFocalDistance() {
        return wrapperJNI.Camera_getMaxFocalDistance(this.swigCPtr, this);
    }

    public double getMinFocalDistance() {
        return wrapperJNI.Camera_getMinFocalDistance(this.swigCPtr, this);
    }

    public void setFocalDistance(double d) {
        wrapperJNI.Camera_setFocalDistance(this.swigCPtr, this, d);
    }

    public double getNear() {
        return wrapperJNI.Camera_getNear(this.swigCPtr, this);
    }

    public int saveImage(String string, int n) {
        return wrapperJNI.Camera_saveImage(this.swigCPtr, this, string, n);
    }

    public boolean hasRecognition() {
        return wrapperJNI.Camera_hasRecognition(this.swigCPtr, this);
    }

    public void recognitionEnable(int n) {
        wrapperJNI.Camera_recognitionEnable(this.swigCPtr, this, n);
    }

    public void recognitionDisable() {
        wrapperJNI.Camera_recognitionDisable(this.swigCPtr, this);
    }

    public int getRecognitionSamplingPeriod() {
        return wrapperJNI.Camera_getRecognitionSamplingPeriod(this.swigCPtr, this);
    }

    public int getRecognitionNumberOfObjects() {
        return wrapperJNI.Camera_getRecognitionNumberOfObjects(this.swigCPtr, this);
    }

    private CameraRecognitionObject getRecognitionObjectsPrivate() {
        long l = wrapperJNI.Camera_getRecognitionObjectsPrivate(this.swigCPtr, this);
        return l == 0L ? null : new CameraRecognitionObject(l, false);
    }

    public boolean hasRecognitionSegmentation() {
        return wrapperJNI.Camera_hasRecognitionSegmentation(this.swigCPtr, this);
    }

    public void enableRecognitionSegmentation() {
        wrapperJNI.Camera_enableRecognitionSegmentation(this.swigCPtr, this);
    }

    public void disableRecognitionSegmentation() {
        wrapperJNI.Camera_disableRecognitionSegmentation(this.swigCPtr, this);
    }

    public boolean isRecognitionSegmentationEnabled() {
        return wrapperJNI.Camera_isRecognitionSegmentationEnabled(this.swigCPtr, this);
    }

    public int[] getRecognitionSegmentationImage() {
        return wrapperJNI.Camera_getRecognitionSegmentationImage(this.swigCPtr, this);
    }

    public int saveRecognitionSegmentationImage(String string, int n) {
        return wrapperJNI.Camera_saveRecognitionSegmentationImage(this.swigCPtr, this, string, n);
    }

    private CameraRecognitionObject getRecognitionObject(int n) {
        return new CameraRecognitionObject(wrapperJNI.Camera_getRecognitionObject(this.swigCPtr, this, n), true);
    }
}

