/*
 * Decompiled with CFR 0.152.
 */
package com.cyberbotics.webots.controller;

import com.cyberbotics.webots.controller.Camera;
import com.cyberbotics.webots.controller.Device;
import com.cyberbotics.webots.controller.ImageRef;
import com.cyberbotics.webots.controller.wrapperJNI;

public class Display
extends Device {
    private transient long swigCPtr;
    public static final int RGB = 3;
    public static final int RGBA = 4;
    public static final int ARGB = 5;
    public static final int BGRA = 6;
    public static final int ABGR = 7;

    protected Display(long l, boolean bl) {
        super(wrapperJNI.Display_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(Display display) {
        return display == null ? 0L : display.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                wrapperJNI.delete_Display(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void drawPolygon(int[] nArray, int[] nArray2) {
        this.drawPolygon(nArray, nArray2, Math.min(nArray.length, nArray2.length));
    }

    public void fillPolygon(int[] nArray, int[] nArray2) {
        this.fillPolygon(nArray, nArray2, Math.min(nArray.length, nArray2.length));
    }

    public Display(String string) {
        this(wrapperJNI.new_Display(string), true);
    }

    public int getWidth() {
        return wrapperJNI.Display_getWidth(this.swigCPtr, this);
    }

    public int getHeight() {
        return wrapperJNI.Display_getHeight(this.swigCPtr, this);
    }

    public void setColor(int n) {
        wrapperJNI.Display_setColor(this.swigCPtr, this, n);
    }

    public void setAlpha(double d) {
        wrapperJNI.Display_setAlpha(this.swigCPtr, this, d);
    }

    public void setOpacity(double d) {
        wrapperJNI.Display_setOpacity(this.swigCPtr, this, d);
    }

    public void setFont(String string, int n, boolean bl) {
        wrapperJNI.Display_setFont(this.swigCPtr, this, string, n, bl);
    }

    public void attachCamera(Camera camera) {
        wrapperJNI.Display_attachCamera(this.swigCPtr, this, Camera.getCPtr(camera), camera);
    }

    public void detachCamera() {
        wrapperJNI.Display_detachCamera(this.swigCPtr, this);
    }

    public void drawPixel(int n, int n2) {
        wrapperJNI.Display_drawPixel(this.swigCPtr, this, n, n2);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        wrapperJNI.Display_drawLine(this.swigCPtr, this, n, n2, n3, n4);
    }

    public void drawRectangle(int n, int n2, int n3, int n4) {
        wrapperJNI.Display_drawRectangle(this.swigCPtr, this, n, n2, n3, n4);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        wrapperJNI.Display_drawOval(this.swigCPtr, this, n, n2, n3, n4);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        wrapperJNI.Display_drawPolygon(this.swigCPtr, this, nArray, nArray2, n);
    }

    public void drawText(String string, int n, int n2) {
        wrapperJNI.Display_drawText(this.swigCPtr, this, string, n, n2);
    }

    public void fillRectangle(int n, int n2, int n3, int n4) {
        wrapperJNI.Display_fillRectangle(this.swigCPtr, this, n, n2, n3, n4);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        wrapperJNI.Display_fillOval(this.swigCPtr, this, n, n2, n3, n4);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        wrapperJNI.Display_fillPolygon(this.swigCPtr, this, nArray, nArray2, n);
    }

    public ImageRef imageNew(int n, int n2, int[] nArray, int n3) {
        long l = wrapperJNI.Display_imageNew(this.swigCPtr, this, n, n2, nArray, n3);
        return l == 0L ? null : new ImageRef(l, false);
    }

    public ImageRef imageCopy(int n, int n2, int n3, int n4) {
        long l = wrapperJNI.Display_imageCopy(this.swigCPtr, this, n, n2, n3, n4);
        return l == 0L ? null : new ImageRef(l, false);
    }

    public void imagePaste(ImageRef imageRef, int n, int n2, boolean bl) {
        wrapperJNI.Display_imagePaste__SWIG_0(this.swigCPtr, this, ImageRef.getCPtr(imageRef), imageRef, n, n2, bl);
    }

    public void imagePaste(ImageRef imageRef, int n, int n2) {
        wrapperJNI.Display_imagePaste__SWIG_1(this.swigCPtr, this, ImageRef.getCPtr(imageRef), imageRef, n, n2);
    }

    public ImageRef imageLoad(String string) {
        long l = wrapperJNI.Display_imageLoad(this.swigCPtr, this, string);
        return l == 0L ? null : new ImageRef(l, false);
    }

    public void imageSave(ImageRef imageRef, String string) {
        wrapperJNI.Display_imageSave(this.swigCPtr, this, ImageRef.getCPtr(imageRef), imageRef, string);
    }

    public void imageDelete(ImageRef imageRef) {
        wrapperJNI.Display_imageDelete(this.swigCPtr, this, ImageRef.getCPtr(imageRef), imageRef);
    }
}

