/*
 * Decompiled with CFR 0.152.
 */
package com.cyberbotics.webots.controller;

import com.cyberbotics.webots.controller.Device;
import com.cyberbotics.webots.controller.LidarPoint;
import com.cyberbotics.webots.controller.wrapperJNI;

public class Lidar
extends Device {
    private transient long swigCPtr;

    protected Lidar(long l, boolean bl) {
        super(wrapperJNI.Lidar_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(Lidar lidar) {
        return lidar == null ? 0L : lidar.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                wrapperJNI.delete_Lidar(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public LidarPoint[] getPointCloud() {
        int n = wrapperJNI.Lidar_getNumberOfPoints(this.swigCPtr, this);
        LidarPoint[] lidarPointArray = new LidarPoint[n];
        for (int i = 0; i < n; ++i) {
            lidarPointArray[i] = this.getPoint(i);
        }
        return lidarPointArray;
    }

    public LidarPoint[] getLayerPointCloud(int n) {
        int n2 = wrapperJNI.Lidar_getHorizontalResolution(this.swigCPtr, this);
        LidarPoint[] lidarPointArray = new LidarPoint[n2];
        for (int i = 0; i < n2; ++i) {
            lidarPointArray[i] = this.getLayerPoint(n, i);
        }
        return lidarPointArray;
    }

    public Lidar(String string) {
        this(wrapperJNI.new_Lidar(string), true);
    }

    public void enable(int n) {
        wrapperJNI.Lidar_enable(this.swigCPtr, this, n);
    }

    public void enablePointCloud() {
        wrapperJNI.Lidar_enablePointCloud(this.swigCPtr, this);
    }

    public void disable() {
        wrapperJNI.Lidar_disable(this.swigCPtr, this);
    }

    public void disablePointCloud() {
        wrapperJNI.Lidar_disablePointCloud(this.swigCPtr, this);
    }

    public int getSamplingPeriod() {
        return wrapperJNI.Lidar_getSamplingPeriod(this.swigCPtr, this);
    }

    public boolean isPointCloudEnabled() {
        return wrapperJNI.Lidar_isPointCloudEnabled(this.swigCPtr, this);
    }

    public float[] getRangeImage() {
        return wrapperJNI.Lidar_getRangeImage(this.swigCPtr, this);
    }

    public float[] getLayerRangeImage(int n) {
        return wrapperJNI.Lidar_getLayerRangeImage(this.swigCPtr, this, n);
    }

    private LidarPoint getPointCloudPrivate() {
        long l = wrapperJNI.Lidar_getPointCloudPrivate(this.swigCPtr, this);
        return l == 0L ? null : new LidarPoint(l, false);
    }

    private LidarPoint getLayerPointCloudPrivate(int n) {
        long l = wrapperJNI.Lidar_getLayerPointCloudPrivate(this.swigCPtr, this, n);
        return l == 0L ? null : new LidarPoint(l, false);
    }

    public int getNumberOfPoints() {
        return wrapperJNI.Lidar_getNumberOfPoints(this.swigCPtr, this);
    }

    public int getHorizontalResolution() {
        return wrapperJNI.Lidar_getHorizontalResolution(this.swigCPtr, this);
    }

    public int getNumberOfLayers() {
        return wrapperJNI.Lidar_getNumberOfLayers(this.swigCPtr, this);
    }

    public double getMinFrequency() {
        return wrapperJNI.Lidar_getMinFrequency(this.swigCPtr, this);
    }

    public double getMaxFrequency() {
        return wrapperJNI.Lidar_getMaxFrequency(this.swigCPtr, this);
    }

    public double getFrequency() {
        return wrapperJNI.Lidar_getFrequency(this.swigCPtr, this);
    }

    public void setFrequency(double d) {
        wrapperJNI.Lidar_setFrequency(this.swigCPtr, this, d);
    }

    public double getFov() {
        return wrapperJNI.Lidar_getFov(this.swigCPtr, this);
    }

    public double getVerticalFov() {
        return wrapperJNI.Lidar_getVerticalFov(this.swigCPtr, this);
    }

    public double getMinRange() {
        return wrapperJNI.Lidar_getMinRange(this.swigCPtr, this);
    }

    public double getMaxRange() {
        return wrapperJNI.Lidar_getMaxRange(this.swigCPtr, this);
    }

    private LidarPoint getPoint(int n) {
        return new LidarPoint(wrapperJNI.Lidar_getPoint(this.swigCPtr, this, n), true);
    }

    private LidarPoint getLayerPoint(int n, int n2) {
        return new LidarPoint(wrapperJNI.Lidar_getLayerPoint(this.swigCPtr, this, n, n2), true);
    }
}

