/*
 * Decompiled with CFR 0.152.
 */
package com.cyberbotics.webots.controller;

import com.cyberbotics.webots.controller.Device;
import com.cyberbotics.webots.controller.RadarTarget;
import com.cyberbotics.webots.controller.wrapperJNI;

public class Radar
extends Device {
    private transient long swigCPtr;

    protected Radar(long l, boolean bl) {
        super(wrapperJNI.Radar_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(Radar radar) {
        return radar == null ? 0L : radar.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                wrapperJNI.delete_Radar(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public RadarTarget[] getTargets() {
        int n = wrapperJNI.Radar_getNumberOfTargets(this.swigCPtr, this);
        RadarTarget[] radarTargetArray = new RadarTarget[n];
        for (int i = 0; i < n; ++i) {
            radarTargetArray[i] = this.getTarget(i);
        }
        return radarTargetArray;
    }

    public Radar(String string) {
        this(wrapperJNI.new_Radar(string), true);
    }

    public void enable(int n) {
        wrapperJNI.Radar_enable(this.swigCPtr, this, n);
    }

    public void disable() {
        wrapperJNI.Radar_disable(this.swigCPtr, this);
    }

    public int getSamplingPeriod() {
        return wrapperJNI.Radar_getSamplingPeriod(this.swigCPtr, this);
    }

    public int getNumberOfTargets() {
        return wrapperJNI.Radar_getNumberOfTargets(this.swigCPtr, this);
    }

    private RadarTarget getTargetsPrivate() {
        long l = wrapperJNI.Radar_getTargetsPrivate(this.swigCPtr, this);
        return l == 0L ? null : new RadarTarget(l, false);
    }

    public double getMinRange() {
        return wrapperJNI.Radar_getMinRange(this.swigCPtr, this);
    }

    public double getMaxRange() {
        return wrapperJNI.Radar_getMaxRange(this.swigCPtr, this);
    }

    public double getHorizontalFov() {
        return wrapperJNI.Radar_getHorizontalFov(this.swigCPtr, this);
    }

    public double getVerticalFov() {
        return wrapperJNI.Radar_getVerticalFov(this.swigCPtr, this);
    }

    private RadarTarget getTarget(int n) {
        return new RadarTarget(wrapperJNI.Radar_getTarget(this.swigCPtr, this, n), true);
    }
}

